//
//  OPFileController.h
//  Image Downloader
//
//  Created by Nathan Van Fleet on 2015-05-29.
//  Copyright (c) 2015 Nathan Van Fleet. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "OPDataModuleProtocol.h"

typedef NS_ENUM(NSUInteger, OPProcessorState) {
	OPProcessorStateIdle = 0,
	OPProcessorStateRunning,
	OPProcessorStateCancelled,
	OPProcessorStateStopped,
};

@class OPDataController;

@protocol OPDataControllerDelegate <NSObject>
@required
- (void)controller:(OPDataController *)controller didCompleteWithResult:(id)result error:(NSError *)error;
- (void)controller:(OPDataController *)controller didReachPercentCompletion:(float)percent activeModule:(NSUInteger)activeModule moduleCount:(NSUInteger)moduleCount;
@end

@interface OPDataController : NSObject
@property (readonly, nonatomic) OPProcessorState state;
@property (readonly, nonatomic) NSMutableSet *referenceObjects;
@property (readonly, nonatomic) NSString *identifier;
@property (weak, nonatomic) id <OPDataControllerDelegate> delegate;
@property (readonly, nonatomic, getter=isBackgroundThreaded) BOOL backgroundThreaded;

- (void)start;
- (void)cancel;
- (instancetype)initWithModules:(NSArray *)modules identifier:(NSString *)identifier backgroundThreaded:(BOOL)backgroundThreaded;
@end
